//-----------------------------------------------------------------------------------
//sai_Scenefile.js
//-----------------------------------------------------------------------------------
/*:ja
 * @plugindesc 補助ウインドウを使ったSS付セーブ画面
 *
 * @param bgBitmapFile
 * @desc セーブ／ロード画面背景にするビットマップファイルです。
 * img/pictures に置いてください。
 * @default 
 *
 *
 * @param List X
 * @desc セーブファイルリストの位置Xです。
 * @default 100
 *
 * @param List Y
 * @desc セーブファイルリストの位置Yです。
 * @default 120
 *
 * @param List Width
 * @desc セーブファイルリストのウインドウ幅です。
 * @default 280
 *
 * @param List Height
 * @desc セーブファイルリストのウインドウ高さです。
 * @default 380
 *
 * @param List MaxItems
 * @desc セーブファイルリストの数です。
 * @default 10
 *
 * @param List MaxCols
 * @desc セーブファイルリストの列数です。
 * @default 2
 *
 * @param List Opacity
 * @desc セーブファイルリストのウインドウ透過度です。
 * @default 0
 *
 * @param List Font Size
 * @desc セーブファイルリストのフォントサイズです。
 * @default 20
 *
 * @param Help X
 * @desc ヘルプのウインドウ位置Xです。
 * @default 100
 *
 * @param Help Y
 * @desc ヘルプのウインドウ位置Yです。
 * @default 50
 *
 * @param Help Width
 * @desc ヘルプのウインドウ幅です。
 * @default 580
 *
 * @param Help Opacity
 * @desc ヘルプのウインドウ透過度です。
 * @default 0
 *
 * @param Help Font Size
 * @desc ヘルプのフォントサイズです。
 * @default 18
 *
 * @param State X
 * @desc セーブ内容の位置Xです。
 * @default 380
 *
 * @param State Y
 * @desc セーブ内容の位置Yです。
 * @default 120
 *
 * @param State Width
 * @desc セーブ内容のウインドウ幅です。
 * @default 300
 *
 * @param State Height
 * @desc セーブ内容のウインドウ高さです。
 * @default 370
  
 * @param State Opacity
 * @desc セーブ内容のウインドウ透過度です。
 * @default 0
 *
 * @param State Font Size
 * @desc セーブ内容のフォントサイズです。
 * @default 18
 *
 * @param SS X
 * @desc スクリーンショットの表示位置Xです。
 * @default 0
 *
 * @param SS Y
 * @desc スクリーンショットの表示位置Yです。
 * @default 0
 *
 * @param SS Percent
 * @desc スクリーンショットの圧縮率です。
 *この数字が大きいほどデータが重くなります。
 * @default 0.30
 *
 * @param Savetime X
 * @desc セーブ日時の表示位置Xです。
 * @default 0
 *
 * @param Savetime Y
 * @desc セーブ日時の表示位置Yです。
 * @default 190
 *
 * @param Location TEXT
 * @desc マップ名の名称です、制御文字が使えます。
 * @default 記録場所：
 *
 * @param Location TEXT X
 * @desc マップ名の名称表示位置Xです。
 * @default 0
 *
 * @param Location TEXT Y
 * @desc マップ名の名称表示位置Yです。
 * @default 220
 *
 * @param Location X
 * @desc マップ名の表示位置Xです。
 * @default 0
 *
 * @param Location Y
 * @desc マップ名の表示位置Yです。
 * @default 215
 *
 * @param Display Variable ID
 * @desc セーブ画面に表示する変数のIDを指定します。
 * @type variable
 * @default 1
 *
 * @param Variable X
 * @desc 変数の表示位置X座標
 * @default 150
 *
 * @param Variable Y
 * @desc 変数の表示位置Y座標
 * @default 280
 *
 * @help このプラグインには、プラグインコマンドはありません。
 *
 * 制作者：sairi　[Twitter＠sairi55]
 * SPECIALTHANKS
 * 翠様、尾角つの様、剣崎宗二様
 * ツクマテお呼びTwitterで何時も構ってくれるツクラーの皆様
 *  
 *  
 * 使用規約：
 * ジャンル無制限、改変可
 * 素材自体の販売禁止
 * ゲームに含めての再配布は可
 *  
 * クレジットの記載は強制しませんが入れてくれると嬉しいです。
 * あと教えてくれるともっと嬉しいです。
 * 以上宜しくお願いします。
 *  
 *  
*/

(function() {
	var Imported = Imported || {};
Imported.sai_Scenefile = true;
var sai = sai || {}; 

//DataManager.cachedSavefileInfo = {};
// オリジナルのloadSavefileInfoメソッドを退避
//DataManager._originalLoadSavefileInfo = DataManager.loadSavefileInfo;

// キャッシュ対応版のloadSavefileInfoメソッドを定義
//DataManager.loadSavefileInfo = function(savefileId) {
    // キャッシュに情報があればそれを返し、なければオリジナルのメソッドを使用
//    if (!this.cachedSavefileInfo[savefileId]) {
//        this.cachedSavefileInfo[savefileId] = this._originalLoadSavefileInfo.call(this, savefileId);
//    }
//    return this.cachedSavefileInfo[savefileId];
//};

DataManager.originalLoadSavefileInfo = DataManager.loadSavefileInfo;

	var parameters = PluginManager.parameters('sai_Scenefile');
var displayVariableId = Number(parameters['Display Variable ID'] || 1);
    var bgBitmapFile = parameters['bgBitmapFile'] || '';
	sai.list_x = Number(parameters['List X'] || 100);	
	sai.list_y = Number(parameters['List Y'] || 120);	
	sai.list_width = Number(parameters['List Width'] || 280);
	sai.list_height = Number(parameters['List Height'] || 380);
	sai.list_maxItems = Number(parameters['List MaxItems'] || 10);	
	sai.list_maxcols = Number(parameters['List MaxCols'] || 2);	
    sai.list_opacity = Number(parameters['List Opacity'] || 0);	
    sai.list_fontsize = Number(parameters['List Font Size'] || 20);	
	sai.help_x = Number(parameters['Help X'] || 100);	
	sai.help_y = Number(parameters['Help Y'] || 50);	
	sai.help_width = Number(parameters['Help Width'] || 580);
	sai.help_opacity = Number(parameters['Help Opacity'] || 0);	
	sai.help_fontsize = Number(parameters['Help Font Size'] || 18);	
	sai.state_x = Number(parameters['State X'] || 380);	
	sai.state_y = Number(parameters['State Y'] || 120);	
	sai.state_width = Number(parameters['State Width'] || 300);
	sai.state_height = Number(parameters['State Height'] || 370);	
	sai.state_opacity = Number(parameters['State Opacity'] || 0);	
	sai.state_fontsize = Number(parameters['State Font Size'] || 18);	
	sai.ss_x = Number(parameters['SS X'] || 0);	
	sai.ss_y = Number(parameters['SS Y'] || 0);	
	sai.ss_percent = Number(parameters['SS Percent'] || 0.30);	
	sai.savetime_x = Number(parameters['Savetime X'] || 0);	
	sai.savetime_y = Number(parameters['Savetime Y'] || 190);
	sai.location_text = (parameters['Location TEXT'] || '記録場所：');		
	sai.locationtext_x = Number(parameters['Location TEXT X'] || 0);	
	sai.locationtext_y = Number(parameters['Location TEXT Y'] || 220);	
	sai.location_x = Number(parameters['Location X'] || 0);	
	sai.location_y = Number(parameters['Location Y'] || 215);	
		
//Bitmap-----------------------------------------------------------------------------
if (!Bitmap.prototype.save){
    Bitmap.prototype.toDataURL = function(){
 // jpegとPNGサイズが小さくなる方を返す
           var png = this._canvas.toDataURL('image/png');
            var jpeg = this._canvas.toDataURL('image/jpeg');
            return (png.length < jpeg.length) ? png : jpeg;

    };
}

//DataManager-----------------------------------------------------------------------------
var DM_LSImage = DataManager.loadSavefileImages;
DataManager.loadSavefileImages = function(info){
    if (info.snapUrl){
		var DH = Decrypter.hasEncryptedImages;
		Decrypter.hasEncryptedImages = false;
        ImageManager.loadNormalBitmap(info.snapUrl);
		Decrypter.hasEncryptedImages = DH;
    }
    // キャラクター画像の読み込みを削除（必要な場合はコメントアウト解除）
    /*
	if (info.characters) {
        for (var i = 0; i < info.characters.length; i++) {
            ImageManager.loadCharacter(info.characters[i][0]);
        }
    }
    */
};

var DM_MSInfo = DataManager.makeSavefileInfo;//セーブファイルの内容
DataManager.makeSavefileInfo = function(){
    var info = DM_MSInfo.call(this);	
	info.location = $dataMap.displayName || $dataMapInfos[$gameMap.mapId()].name;
	info.map_id = $gameMap.mapId();

    var today = new Date();
    var dateOptions = {
        year: "numeric",
        month: "2-digit",
        day: "2-digit",
        hour: "2-digit",
        minute: "2-digit"
    };
    info.savetime = today.toLocaleDateString("ja-JP", dateOptions);

    var bitmap = this.makeSavefileBitmap();
    if (bitmap) {
        info.snapUrl = bitmap.toDataURL();
    }
    // 追加：任意の変数の値をセーブファイル情報に保存
    info.displayVariable = $gameVariables.value(displayVariableId);
    return info;
};

// 非同期でスクリーンショットを保存
DataManager.scheduleScreenshotSave = function(info) {
    setTimeout(() => {
        var bitmap = this.makeSavefileBitmap();
        if (bitmap) {
            info.snapUrl = bitmap.toDataURL();
        }
    }, 0);
};

DataManager.makeSavefileBitmap = function(){//セーブファイル用のビットマップを作成
    var bitmap = $gameTemp.getSavefileBitmap();
    if (!bitmap){
        return null;
    }
    var scale = Number(sai.ss_percent);
    var newBitmap = new Bitmap(bitmap.width * scale, bitmap.height * scale);
    newBitmap.blt(bitmap, 0, 0, bitmap.width, bitmap.height, 0, 0, newBitmap.width, newBitmap.height);
    return newBitmap;
};

//Game_Temp-----------------------------------------------------------------------------
var Game_Temp_initialize = Game_Temp.prototype.initialize;
Game_Temp.prototype.initialize = function(){
    Game_Temp_initialize.call(this);
    this._savefileBitmap = null;
};

Game_Temp.prototype.setSavefileBitmap = function(bitmap){
    this._savefileBitmap = bitmap;
};

Game_Temp.prototype.getSavefileBitmap = function(){
    if (this._savefileBitmap){
        return this._savefileBitmap;
    }
    else{
        return SceneManager._backgroundBitmap;
    }
};

//---------------------------------------------------------------------------------
Window_SavefileList.prototype.maxItems = function() {
    return Number(sai.list_maxItems);
};
Window_SavefileList.prototype.maxCols = function() {
    return Number(sai.list_maxcols);　
};
Window_SavefileList.prototype.standardFontSize = function() {
    return Number(sai.list_fontsize);
};
Window_Help.prototype.standardFontSize = function() {
    return Number(sai.help_fontsize);
};
SceneManager.snapForBackground = function() {
    this._backgroundBitmap = this.snap();　//モーションブラーを取り外す
};
//----------------------------------------------------------------------------------
var _Scene_File_create = Scene_File.prototype.create;
Scene_File.prototype.create = function() {
    _Scene_File_create.call(this);
	//ステータスウインドウの配置
    this._statusWindow = new Window_SavefileStatus(Number(sai.state_x),Number(sai.state_y),Number(sai.state_width), Number(sai.state_height));
    this._statusWindow.setMode(this.mode());
    this._listWindow.statusWindow = this._statusWindow;
	// セーブ画面全てのウインドウを透明にする
	this._statusWindow.opacity = Number(sai.state_opacity);
	this._helpWindow.opacity = Number(sai.help_opacity);
    this._listWindow.opacity = Number(sai.list_opacity);
	//---------------------------------------
    this._listWindow.callUpdateHelp();
	//ヘルプウインドウの配置
	this._helpWindow.x = Number(sai.help_x);
	this._helpWindow.y = Number(sai.help_y);
	this._helpWindow.width = Number(sai.help_width);
    this.addWindow(this._statusWindow);
	this.addChildAt(this._helpWindow,2); //helpWindowの表示順位を入れ替える		
};

var _Scene_File_start = Scene_File.prototype.start;
Scene_File.prototype.start = function() {
    _Scene_File_start.call(this);
    this._listWindow.ensureCursorVisible();
    this._listWindow.callUpdateHelp();
};

Window_SavefileList.prototype.initialize = function(x, y, width, height) {
    Window_Selectable.prototype.initialize.call(this, Number(sai.list_x), Number(sai.list_y), Number(sai.list_width), Number(sai.list_height));
    this.activate();
    this._mode = null;
};
Window_SavefileList.prototype.itemHeight = function() {
    return this.padding * 1.8;
};

var _Window_SavefileList_callUpdateHelp =
        Window_SavefileList.prototype.callUpdateHelp;
Window_SavefileList.prototype.callUpdateHelp = function() {
    if (this.active && this.statusWindow && this._lastIndex !== this.index()) {
        this._lastIndex = this.index();
        this.statusWindow.setId(this.index() + 1);
    }
};

function Window_SavefileStatus() {
    this.initialize.apply(this, arguments);
}

Window_SavefileStatus.prototype = Object.create(Window_Base.prototype);
Window_SavefileStatus.prototype.constructor = Window_SavefileStatus;

Window_SavefileStatus.prototype.initialize = function(x, y, width, height) {
    Window_Base.prototype.initialize.call(this, x, y, width, height);
    this._id = 1;
};

Window_SavefileStatus.prototype.setMode = function(mode) {
    this._mode = mode;
};

Window_SavefileStatus.prototype.setId = function(id) {
    this._id = id;
	this.contents.fontSize = Number(sai.state_fontsize);
    this.refresh();
};
Window_SavefileStatus.prototype.standardFontSize = function(id) {
    return  Number(sai.state_fontsize);
};

Window_SavefileStatus.prototype.refresh = function() {
    this.contents.clear();
    var id = this._id;
    var info = DataManager.loadSavefileInfo(id);
	var valid = DataManager.isThisGameFile(id);
    if (info){
        var rect = this.contents.rect;
        this.drawSnappedImage(info, rect, valid);
		this.drawFileId(id, rect.x, rect.y);
		this.drawContents(info, rect.x, valid);
    }
};

//セーブステータス画面に表示させる名称と位置------------------------------------
//現状[ファイル名+ID、プレイ時間、地名]、名称変更は''の中の文字で
Window_SavefileStatus.prototype.drawFileId = function(id, x, y) {
	this.drawTextEx((sai.location_text) + ' ', Number(sai.locationtext_x), Number(sai.locationtext_y), 120);
};

// 追加：変数の表示位置
var variableX = Number(parameters['Variable X'] || 150);
var variableY = Number(parameters['Variable Y'] || 280);

Window_SavefileStatus.prototype.drawContents = function(info, x, valid) {
    this.drawText(info.savetime, Number(sai.savetime_x), Number(sai.savetime_y), 200);
    if (info.location) {
        this.drawText(info.location, 100, Number(sai.location_y), 150);
    }

    // 追加：指定した位置に任意の変数の値を表示
    if (info.displayVariable !== undefined) {
        this.drawText("変数：" + info.displayVariable, variableX, variableY, 200);
    }
};

//セーブファイルリストの中身-------------------------------------------------
Window_SavefileList.prototype.drawItem = function(index) {
    var id = index + 1;
    var rect = this.itemRectForText(index);
    this.resetTextColor();
    this.drawFileId(id, rect.x, rect.y);
};

//セーブファイルの画像を表示
Window_SavefileStatus.prototype.drawSnappedImage = function(info, rect, valid){
    if (!(valid && info.snapUrl)){
        return;
    }
　　var DH = Decrypter.hasEncryptedImages;//暗号化してるかどうかのフラグを一旦適当な変数に保存
	Decrypter.hasEncryptedImages = false;//その場合一時的にfalse
    var bitmap = ImageManager.loadNormalBitmap(info.snapUrl);
	Decrypter.hasEncryptedImages = DH;    //フラグを戻す 
    var dh = 0;
    var dw = 0;
    var dx = rect.x + Number(sai.ss_x);　//表示位置X
    var dy = rect.y + Number(sai.ss_y);　　//表示位置Y

    this.changePaintOpacity(true);
    this.contents.blt(bitmap, 0, 0, bitmap.width, bitmap.height, dx, dy, dw, dh);
};

//セーブ画面の背景読み込み
var _Scene_File_createBackground = Scene_File.prototype.createBackground;
Scene_File.prototype.createBackground = function(){
    if(bgBitmapFile){
		Scene_MenuBase.prototype.createBackground.call(this);//追加行
        this._backgroundSprite = new Sprite();
        this._backgroundSprite.bitmap =
         ImageManager.loadPicture(bgBitmapFile);
        this.addChild(this._backgroundSprite);
        return;
    }
    _Scene_File_createBackground.call(this);    // 背景ファイルが無い場合
};


})();



